/**
 * Memory Analyser  version 1.00
 * Copyright (c) 2018, Tycho Veltmeijer.
 * All rights reserved.
**/

#include <stdio.h>
#include "memory_analyser.h"
#include "Filter_Firefox.h"
#include "Filter_Safari.h"
#include "Filter_IE.h"
#include "Filter_Dump.h"
#include "Filter_General.h"
#include "list.h";

#define ARGUMENT_FLAG_HAS_VALUE 0x1
#define ARGUMENT_FLAG_HAS_OPTIONAL_VALUE 0x2

#define AMOUNT_OF_ARGUMENTS 16

char* arguments[AMOUNT_OF_ARGUMENTS] = {"pid", "file", "l", "fsu", "fpa", "fca", "gua", "guu", "sd", "bd", "ssa", "sra", "sca", "iua", "iuu", "ica"};

struct
{   InitiateFilter initiate;
    MEMFUNC			apply;
    Destroy			destroy;
} argumentsFunctions[AMOUNT_OF_ARGUMENTS] =
{
	{0, 0, 0},	//pid
	{0, 0, 0},	//file
	{0, 0, 0},	//l
	{(InitiateFilter) InitiateFirefoxFilter1, (MEMFUNC) ApplyFirefoxFilter1, (Destroy) DestroyFirefoxFilter1}, //fsu
	{(InitiateFilter) InitiateFirefoxFilter2, (MEMFUNC) ApplyFirefoxFilter2, (Destroy) DestroyFirefoxFilter2}, //fpa
	{(InitiateFilter) InitiateFirefoxFilter3, (MEMFUNC) ApplyFirefoxFilter3, (Destroy) DestroyFirefoxFilter3}, //fca
	{(InitiateFilter) InitiateFilterGeneralASCII, (MEMFUNC) ApplyFilterGeneralASCII, (Destroy) DestroyFilterGeneralASCII}, //gua
	{(InitiateFilter) InitiateFilterGeneralUNICODE, (MEMFUNC) ApplyFilterGeneralUNICODE, (Destroy) DestroyFilterGeneralUNICODE},	//guu
	{(InitiateFilter) InitiateDumpSmall, (MEMFUNC) WriteMemoryDump, (Destroy) DestroyDump},	//sd
	{(InitiateFilter) InitiateDumpBig, (MEMFUNC) WriteMemoryDump, (Destroy) DestroyDump},	//bd
	{(InitiateFilter) InitiateSafariFilter2, (MEMFUNC) ApplySafariFilter2, (Destroy) DestroySafariFilter2}, //ssa
	{(InitiateFilter) InitiateSafariFilter1, (MEMFUNC) ApplySafariFilter1, (Destroy) DestroySafariFilter1}, //sra
	{(InitiateFilter) InitiateSafariFilter3, (MEMFUNC) ApplySafariFilter3, (Destroy) DestroySafariFilter3}, //sca
	{(InitiateFilter) InitiateIEFilter1, (MEMFUNC) ApplyIEFilter1, (Destroy) DestroyIEFilter1}, //iua
	{(InitiateFilter) InitiateIEFilter2, (MEMFUNC) ApplyIEFilter2, (Destroy) DestroyIEFilter2}, //iuu
	{(InitiateFilter) InitiateIEFilter3, (MEMFUNC) ApplyIEFilter3, (Destroy) DestroyIEFilter3}  //ica
};

int argumentsFlags[AMOUNT_OF_ARGUMENTS] = {
	ARGUMENT_FLAG_HAS_VALUE,  //pid
	ARGUMENT_FLAG_HAS_VALUE,  //file 
	ARGUMENT_FLAG_HAS_VALUE,  //location
	ARGUMENT_FLAG_HAS_OPTIONAL_VALUE, //Firefox String URL Unicode
	ARGUMENT_FLAG_HAS_OPTIONAL_VALUE, //Firefox Private session URL ASCII search
	ARGUMENT_FLAG_HAS_OPTIONAL_VALUE, //Firefox Cookie Ascii search
	ARGUMENT_FLAG_HAS_OPTIONAL_VALUE, //General URL ASCII search
	ARGUMENT_FLAG_HAS_OPTIONAL_VALUE, //General URL UNICODE search
	0, //small dump
	0, //big dump
	ARGUMENT_FLAG_HAS_OPTIONAL_VALUE, //Safari String ASCII search
	ARGUMENT_FLAG_HAS_OPTIONAL_VALUE, //Safari Recursive String ASCII search
	ARGUMENT_FLAG_HAS_OPTIONAL_VALUE, //Safari Cookie Ascii search
	ARGUMENT_FLAG_HAS_OPTIONAL_VALUE, //Internet Explorer URL search (ASCI)
	ARGUMENT_FLAG_HAS_OPTIONAL_VALUE, //Internet Explorer URL search (UNICODE)
	ARGUMENT_FLAG_HAS_OPTIONAL_VALUE //Internet Explorer Cookie search (ASCII)
};
char* argumentValue[AMOUNT_OF_ARGUMENTS] = {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};

main( int argc, const char* argv[])
{
	DWORD processPid;	//Pid naar het proces dat door het filter gehaalt moet worden
	HANDLE process;		//Handle naar een proces dat door de filters gehaalt moet worden
	HANDLE inputFile;	//Handle naar bestand dat door de filters gehaalt moet worden
	int i, j;			//Gebruikt in een For-loop
	int analyse_type;	//kan ANALYSE_FILE of ANALYSE_MEMORY zijn
	int exitCode;		//Het returnwaarde van een proces als deze gesloten is
	char* openProcess="firefox.exe";	//Hier komt de naam van het proces dat door het filter gehaalt moet worden, standaart staat die op Firefox.exe
	char* defaultOpenProcess;
	char* location="C:\\temp\\dump\\";	//Output locatie, staat standaart op C:\temp\dump\ 
	char* processName;	//Als er meerdere processen tegelijk door de filters gehaalt moet worden, wordt dit gedaan dmv zichzelf meerdere keren te starten met andere commandlines, het pad naar dit programma komt op hier te staan
	char* commandLine;	//De commandline die in dezelfde situatie wordt gebruikt als "procesName"
	char* newLocation;	//De nieuwe output locatie wordt de output locatie + PID van het proces dat door het filter wordt gehaald, wordt in dezelfde situatie gebruikt als "procesName"
	STARTUPINFO startupInfo = {0};		//Wordt gebruikt tijdens CreateProcess
	LPPROCESS_INFORMATION proc = {0};	//Wordt gebruikt tijdens CreateProcess
	MEMFUNC_STRUCT* mem_functions;		//Een structuur met daarin alle functies die aangeroepen moeten worden tijdens het analyseren van een stuk geheugen
	MEMFUNC_STRUCT* tmp_mem_functions;	//Wordt gebruikt om de structuur mem_functions te vullen

	/*Zet de waardes op nul*/
	processPid = 0;
	inputFile = 0;
	process = 0;
	defaultOpenProcess = openProcess;
	/*Vul de grote van de structuur STARTUPINFO in*/
	startupInfo.cb = sizeof(STARTUPINFO);

	/*Vraag het pad aan naar dit programma*/
	processName = (char*) malloc(MAX_PATH+1);
	GetModuleFileName(0, processName, MAX_PATH);

	/*Vraag geheugen op voor nieuwe commandline en locatie (indien er meerdere processen draaien met dezelfde naam wordt dit gebruikt)*/
	commandLine = (char*) malloc(MAX_PATH *2 + 2);
	newLocation = (char*) malloc(MAX_PATH+1);
	proc = (LPPROCESS_INFORMATION) malloc(sizeof(PPROCESS_INFORMATION));

	/*Verwerk de argumenten en zet argumentValue op -1 als het argument genoemd staat zonder zelf een argument te hebbene en 0 als het argument niet voorkomt.*/
	for(i=1; i<argc; i++) {
		if(argv[i][0]=='-') {
			for(j=0; j<AMOUNT_OF_ARGUMENTS; j++) {
				if(stricmp((char*) argv[i]+1, arguments[j])==0) {
					if((argumentsFlags[j]&ARGUMENT_FLAG_HAS_VALUE && argc!=i)
					|| (argumentsFlags[j]&ARGUMENT_FLAG_HAS_OPTIONAL_VALUE && argc-1!=i && argv[i+1][0]!='-')) {
						argumentValue[j] = (char*) argv[i+1];
						i++;
						break;
					} else if(!(argumentsFlags[j]&ARGUMENT_FLAG_HAS_VALUE)) {
						argumentValue[j] = (char*) -1;
					}
				}
			}
		} else {
			openProcess = (char*)argv[i];
		}
	}

	if(!(argumentValue[ARGUMENT_PID]!=0 && defaultOpenProcess!=openProcess))
		printf(
			"-----------------------------------------------------------------------\n"
			"|                     Memory Analyser  version 1.00                    |\n"
			"|                 Copyright (c) 2018, Tycho Veltmeijer.                |\n"
			"|                         All rights reserved.                         |\n"
			"-----------------------------------------------------------------------\n\n");

	if(argumentValue[ARGUMENT_FILE] == 0) {
		/*Er wordt een PID meegegeven, zet deze om in een integer*/
		if(argumentValue[ARGUMENT_PID]!=0) {
			processPid = strtol(argumentValue[ARGUMENT_PID], NULL, 10);
			openProcess = 0;
		}

		/*Er is een procesnaam meegegeven, vind het bijbehorende PID*/
		if(openProcess!=0) {
			processPid = FindProcess(openProcess, 0);
			if(processPid==0) {
				MessageBox(0, "Het opgegeven proces draaid niet.","Fout",0x10);
				return 0;
			}

			/*Indien er meerdere PID's zijn met deze processnaam, open dit programma weer met aangepast commandline.*/
			if(FindProcess(openProcess, processPid) != 0) {
				/*Vul de standaart output locatie in indien deze niet is meegegeven in de commandline*/
				if(argumentValue[ARGUMENT_LOCATION]==0)
					argumentValue[ARGUMENT_LOCATION] = location;
				do {
					/*Maak een nieuwe outputmap aan, met als naam het PID*/
					printf("Processing PID %d \n", processPid);
					sprintf(newLocation, "%s/%d", argumentValue[ARGUMENT_LOCATION], processPid);
					CreateDirectory(newLocation, 0); 

					/*Pas de commandline aan en voeg nieuwe outputmap en het PID toe*/
					sprintf(commandLine, "%s -pid %d -l \"%s\"", GetCommandLine(), processPid, newLocation);

					/*Start het process*/
					CreateProcess(processName, commandLine, 0, 0, 0, 0, 0, 0, &startupInfo, proc);

					/*Wacht totdat het proces gesloten is*/
					exitCode=STILL_ACTIVE;
					while(exitCode==STILL_ACTIVE) {
						Sleep(100);
						GetExitCodeProcess(proc->hProcess, (LPDWORD) &exitCode);
					}

					/*Controleer of er nog meer processen draaien met deze naam*/
					processPid = FindProcess(openProcess, processPid);
					if(processPid==0) {
						return 0;
					}

					printf("\n");
				} while(1);
			}
		}

		/*Indien er maar n proces is, probeer een handle met alle rechten er naar toe te openen*/
		process = OpenProcess(PROCESS_ALL_ACCESS, 0, processPid);
		if(process==NULL) {
			MessageBox(0, "Kon het process niet openen.","Fout",0x10);
			return 0;
		}
	} else {
		/*Er moet een bestand geannalyseerd worden, open dit bestand.*/
		inputFile = CreateFile(argumentValue[ARGUMENT_FILE],
			GENERIC_READ,
			FILE_SHARE_READ,
			NULL,
			OPEN_EXISTING,
			NULL,
			NULL
		);

		/*Geef de foutmelding weer indien het openen mislukt*/
		if(inputFile==INVALID_HANDLE_VALUE) {
			showLastError();
			exit(0);
		}

	}

	/*Indien er geen filters aangezet zijn in de commandline, zet de filters aan die toepasbaar zijn op Firefox*/
	if(argumentValue[ARGUMENT_FSU] == (char*) 0
	&& argumentValue[ARGUMENT_FPA] == (char*) 0
	&& argumentValue[ARGUMENT_FCA] == (char*) 0
	&& argumentValue[ARGUMENT_GUA] == (char*) 0
	&& argumentValue[ARGUMENT_GUU] == (char*) 0
	&& argumentValue[ARGUMENT_SD] == (char*) 0
	&& argumentValue[ARGUMENT_BD] == (char*) 0
	&& argumentValue[ARGUMENT_SSA] == (char*) 0
	&& argumentValue[ARGUMENT_SRA] == (char*) 0
	&& argumentValue[ARGUMENT_SCA] == (char*) 0
	&& argumentValue[ARGUMENT_IUA] == (char*) 0
	&& argumentValue[ARGUMENT_IUU] == (char*) 0
	&& argumentValue[ARGUMENT_ICA] == (char*) 0) {
		argumentValue[ARGUMENT_FSU] = (char*) -1;
		argumentValue[ARGUMENT_FPA] = (char*) -1;
		argumentValue[ARGUMENT_FCA] = (char*) -1;
		argumentValue[ARGUMENT_GUA] = (char*) -1;
		argumentValue[ARGUMENT_GUU] = (char*) -1;
		argumentValue[ARGUMENT_SD] = (char*) -1;
	}

	/*Maak een strucutre aan waar alle functies (filters) inkomen die opgeroepen moeten worden bij de memory analyse*/
	mem_functions = (MEMFUNC_STRUCT*) malloc(sizeof(MEMFUNC_STRUCT));

	/*Vul de standaart output locatie in indien deze niet is meegegeven in de commandline*/
	if(argumentValue[ARGUMENT_LOCATION]==0)
		argumentValue[ARGUMENT_LOCATION] = location;
	/*Zet de eerste functie op nul, zodat duidelijk is dat deze nog niet is ingevuld*/
	tmp_mem_functions = mem_functions;
	tmp_mem_functions->func = 0;

	/*Controleer of het hier om een bestandsanalyse gaat of een memory analyse*/
	if(inputFile==(HANDLE) 0)
		analyse_type = ANALYSE_MEMORY;
	else
		analyse_type = ANALYSE_FILE;

	/*Vul mem_functions in met alle filters die moeten worden opgeroepen tijdens de memory analyse*/
	for(i=0; i<AMOUNT_OF_ARGUMENTS; i++) {
		if(argumentsFunctions[i].initiate !=0 && argumentValue[i]!=0) {
			if(tmp_mem_functions->func!=0) {
				tmp_mem_functions->next = (MEMFUNC_STRUCT*) malloc(sizeof(MEMFUNC_STRUCT));
				tmp_mem_functions = tmp_mem_functions->next;
			}
			tmp_mem_functions->param = argumentsFunctions[i].initiate(argumentValue[ARGUMENT_LOCATION], argumentValue[i], analyse_type);
			tmp_mem_functions->func = argumentsFunctions[i].apply;
			tmp_mem_functions->funcDestroy = argumentsFunctions[i].destroy;
			tmp_mem_functions->flags = 0;
		}
	}

	/*Zet de volgende op 0 zodat duidelijk is dat hier de keten stopt*/
	tmp_mem_functions->next = 0;
	
	/*Doorzoek een bestand of virtuele geheugen van een process*/
	if(inputFile==(HANDLE) 0) {
		searchMemory(process, mem_functions);
	} else {
		searchFile(inputFile, mem_functions);
	}

	/*Geef het geheugen vrij (en mogelijk doet de functie nog een afwerking, zoals bij Internet Explorer Cookies het geval is)*/
	tmp_mem_functions = mem_functions;
	while(tmp_mem_functions!=0) {
		tmp_mem_functions->funcDestroy((MEMFUNC_STRUCT*) tmp_mem_functions->param);
		tmp_mem_functions = tmp_mem_functions->next;
	}

	/*Klaar :)*/
	printf("done");
	return 0;
}

void showLastError() {
	showError(GetLastError());
}

void showError(int code) {
	char* lpBuffer;

	FormatMessage(FORMAT_MESSAGE_ALLOCATE_BUFFER+FORMAT_MESSAGE_FROM_SYSTEM, 0, code, LANG_NEUTRAL, (char*) &lpBuffer, 0, 0);
	MessageBox(0, lpBuffer, "Error", MB_ICONERROR+MB_OK);
	LocalFree(lpBuffer);
} 

/*De filters zijn gemaakt voor virtueel geheugen, geladen uit een proces. Om de filters ook werkend te krijgen met een bestand
wordt de structuur MEMORY_BASIC_INFORMATION met neppe gegevens gevuld en wordt gebruikt gemaakt van een extra overflow buffer.
 Bij het memory had je al een overflow, hier werd niks mee gedaan, bij bestandsanalyse heb je een extra overflow die wordt gevult met data uit het bestand.
 De buffer is er voor om niet een URL of cookie af te kappen op de plek waar de buffer stopt, de overflow mag dan ook alleen gebruikt worden om 
 een gevonden URL af te maken, er mag niet meer gezocht worden in de overflow buffer naar nieuwe URL's of cookies. Het stuk overflow is in de volgende keer
 dat de filter wordt opgeroepen weer aanwezig, maar dan niet meer in het overflow gedeelte waardoor de URL en Cookie in dat deel meegenomen kan worden.
*/
int searchFile(HANDLE inputFile, MEMFUNC_STRUCT* memf) {
	int retv;
	char* fileContents;
	long long fileSize=0;
	long long filepos =0;
	long readSize=0;
	LARGE_INTEGER currentPos;
	MEMFUNC_STRUCT* tmp_memf;
	MEMORY_BASIC_INFORMATION memInfo={0};
	GetFileSizeEx(inputFile, (PLARGE_INTEGER) &fileSize);

	/*Vraag een buffer op waar het bestand op kan, of indien groter wordt het default_buffer_size*/
	if(fileSize + default_empty_overflow_size < default_buffer_size) {
		fileContents = (char*) malloc(fileSize + default_empty_overflow_size);
		if(fileContents == 0) {
			showLastError();
			exit(0);
		}

	} else {
		fileContents = (char*) malloc(default_buffer_size);
		if(fileContents == 0) {
			showLastError();
			exit(0);
		}
	}

	filepos = fileSize;

	/*Stap voor stap een bestand uitlezen en analyseren met de geselecteerde filters*/
	while(filepos!=0) {
		/*De rest van het bestand uitlezen, of indien groter wordt  default_buffer_size - default_empty_overflow_size uitgelezen*/
		if(filepos + default_empty_overflow_size > default_buffer_size)
			readSize = default_buffer_size - default_empty_overflow_size;
		else
			readSize = filepos;

		printf("Reading at position %lld / %lld Readingsize: %d... (%-3f%%)\n", fileSize - filepos, fileSize, readSize, ((((float)fileSize - (float)filepos)/ (float)fileSize) *100));

		/*Lees het bestand uit en vul memInfo in met neppe gegezens (het is immers geen geheugen, maar een bestand) zodat het filter er mee kan werken.*/
		ReadFile(inputFile, fileContents, readSize, (LPDWORD) &retv, 0);
		VirtualQuery((LPCVOID) fileContents, &memInfo, sizeof(MEMORY_BASIC_INFORMATION));
		memInfo.BaseAddress = (PVOID) (fileSize - filepos);

		/*Omdat er meer uit het bestand is uitgelezen dan mag worden geanalyseerd wordt de pointer in het bestand weer terug gezet*/
		if(filepos + default_empty_overflow_size > default_buffer_size) {
			memInfo.RegionSize = readSize - default_buffer_overflow_size;
			filepos -= retv - default_buffer_overflow_size;			
		} else {
			memInfo.RegionSize = readSize;
			filepos -= readSize;			
		}
		currentPos.QuadPart = fileSize - filepos;
		if(SetFilePointerEx(inputFile, currentPos, 0, FILE_BEGIN)==0) 
			showLastError();

		/*Vraag huidige positie aan*/
		currentPos.QuadPart = 0;
		SetFilePointerEx(inputFile, currentPos, &currentPos, FILE_CURRENT);

		filepos = fileSize - currentPos.QuadPart;

		/*Draai het filter over het stuk ingeladen bestand*/
		tmp_memf = memf;
		printf("Processing memory...\n");
		while(tmp_memf!=0) { /*Roep alle functies aan in de MEMFUNC_STRUCT*/
			retv = tmp_memf->func(tmp_memf->param, 0, &memInfo, fileContents, readSize);

			if(tmp_memf->flags&MS_RETURN_ON_ZERO && retv==0)
				return retv;

			if(tmp_memf->flags&MS_RETURN_NOT_ZERO && retv!=0)
				return retv;

			tmp_memf = tmp_memf->next;
		}
	}

	free(fileContents);
}

//Deze methode leest Virtueel geheugen uit en roept de functies in MEMFUNC_STRUCT aan om deze te analyseren.
int searchMemory(HANDLE process, MEMFUNC_STRUCT* memf) {
	memlong memLocation;
	int retv;
	int oldProtect=-1;
	char* buff=0;
	MEMORY_BASIC_INFORMATION memInfo;
	MEMFUNC_STRUCT* tmp_memf;

	for (memLocation = min_mem_location; memLocation < max_mem_location; memLocation++) {
		/*Vraag informatie over het stuk geheugen op: de groote, rechten */
		retv = VirtualQueryEx(process, (LPCVOID) memLocation, &memInfo, sizeof(MEMORY_BASIC_INFORMATION));
		if(retv!=0 && retv==sizeof(MEMORY_BASIC_INFORMATION)) { //Methode VirtualQueryEx moet goed verlopen zijn
			oldProtect=-1;

			if(memInfo.State!=MEM_FREE && memInfo.State!=MEM_RESERVE) { //Controleren of het geheugen gebruikt wordt door het proces
				/*Controleren of het geheugen leesbaar is, zoniet, verander de rechten zodat deze leesbaar is*/
				retv = memInfo.Protect;
				retv = retv & PAGE_NOACCESS;
				retv |= (memInfo.Protect) & PAGE_EXECUTE;
				
				if(retv != 0) { //Niet leesbaar? Verander de rechten
					retv = (int) VirtualProtectEx(process, (LPVOID) memInfo.BaseAddress, memInfo.RegionSize, PAGE_EXECUTE_READWRITE, (PDWORD) &oldProtect);
				}
				
				/*Lees virtueel geheugen uit*/
				buff = (char*) malloc(memInfo.RegionSize);
				retv = ReadProcessMemory(process, memInfo.BaseAddress, buff, memInfo.RegionSize, NULL);

				/*Zet oude rechten van geheugen terug*/
				if(oldProtect != -1)
					retv = (int) VirtualProtectEx(process, (LPVOID) memInfo.BaseAddress, memInfo.RegionSize, oldProtect, (PDWORD) &oldProtect);
			} else {
				buff = 0;
			}

			tmp_memf = memf;
			while(tmp_memf!=0) { /*Roep alle functies aan in de MEMFUNC_STRUCT*/
				retv = tmp_memf->func(tmp_memf->param, process, &memInfo, buff, memInfo.RegionSize);

				if(tmp_memf->flags&MS_RETURN_ON_ZERO && retv==0)
					return retv;

				if(tmp_memf->flags&MS_RETURN_NOT_ZERO && retv!=0)
					return retv;

				tmp_memf = tmp_memf->next;
			}

			//Geef de buffer vrij
			if(buff!=0)
				free(buff);

			//Lees het volgende stuk virtueel geheugen uit
			if((memlong) memInfo.BaseAddress + (memlong) memInfo.RegionSize - 1 == memLocation)
				break;
			else
				memLocation = (memlong) memInfo.BaseAddress + (memlong) memInfo.RegionSize - 1;
		} else {
			break;
		}
	}
}

/*Roep CreateMemoryDump aan en schrijf de string "" 
naar het bestand dat aangeeft dat een een UNICODE-text bestand is*/
DUMP_SESSION* CreateUNICODEMemoryDump(char* outputDir, char* outputFile, char* optionalOutputFile, int flags) {
	int writtenBytes=0;
	DUMP_SESSION* newdump;

	newdump = CreateMemoryDump(outputDir, outputFile, optionalOutputFile, flags);
	WriteFile(newdump->dumpFile,"", 2, (LPDWORD) &writtenBytes, NULL);
	if(newdump->optionalDumpFile) WriteFile(newdump->optionalDumpFile,"", 2, (LPDWORD) &writtenBytes, NULL);

	return newdump;
}

//Maak een DUMP_SESSION structure aan
DUMP_SESSION* CreateMemoryDump(char* outputDir, char* outputFile, char* optionalOutputFile, int flags) {
	DUMP_SESSION* newdump;
	char* outPath=0;
	char* openFile=0;

	if(outputDir!=0) {
		outPath = (char*) malloc(strlen(outputDir) + strlen(outputFile) + 10);
		strcpy(outPath, outputDir);
		if(outputDir[strlen(outputDir)-1] != '/' && outputDir[strlen(outputDir)-1] != '\\')
			strcat(outPath, "\\");
		strcat(outPath, outputFile);
		openFile = outPath;
	} else {
		openFile = outputFile;
	}


	newdump = (DUMP_SESSION*) malloc(sizeof(DUMP_SESSION));
	newdump->dumpFile = CreateFile(openFile,
		(GENERIC_READ | GENERIC_WRITE),
		0,
		NULL,
		CREATE_ALWAYS,
		0,
		0);

	if(outPath!=0)
		free(outPath);

	if(optionalOutputFile!=0) {
		if(outputDir!=0) {
			outPath = (char*) malloc(strlen(outputDir) + strlen(optionalOutputFile) + 10);
			strcpy(outPath, outputDir);
			if(outputDir[strlen(outputDir)-1] != '/' && outputDir[strlen(outputDir)-1] != '\\')
				strcat(outPath, "\\");
			strcat(outPath, optionalOutputFile);
			openFile = outPath;
		} else {
			openFile = outputFile;
		}
		newdump->optionalDumpFile = CreateFile(openFile,
			(GENERIC_READ | GENERIC_WRITE),
			0,
			NULL,
			CREATE_ALWAYS,
			0,
			0);

		if(outPath!=0)
			free(outPath);
	} else {
		newdump->optionalDumpFile=0;
	}

	newdump->flags = flags;
	newdump->string_location = (char*) malloc(1000);
	newdump->unlocated_size = 0;
	newdump->zerobuf = (char*) malloc(1000);
	memset(newdump->zerobuf, 0, 1000);

	return newdump;
}

//Verwijder een DUMP_SESSION structure
void Destroy_MemoryDump(DUMP_SESSION* dumpsess) {
	CloseHandle(dumpsess->dumpFile);
	if(dumpsess->optionalDumpFile!=0) CloseHandle(dumpsess->optionalDumpFile);
	free(dumpsess->string_location);
	free(dumpsess->zerobuf);
	free(dumpsess);
}

/* functie FindProcess
	Deze functie zoekt het aangegeven programma en keert het ProcesId terug

	name het programma dat je wil zoeken (bijv firefox.exe)
	nextProcess De vorige ProcesId die gevonden is, op deze manier krijg je de volgende PID.
*/
DWORD FindProcess(char *name, DWORD nextProcess) {
	PROCESSENTRY32 procEntry;
	int foundPreviousProcess=0;

	HANDLE hSnap = CreateToolhelp32Snapshot(TH32CS_SNAPPROCESS, 0); //Een handle voor een 'snapshot' van processen
	if (hSnap == INVALID_HANDLE_VALUE) { //Nog nooit voorgekomen, maar toch...
		return 0 ;
	}

	procEntry.dwSize = sizeof(PROCESSENTRY32);

	if (!Process32First(hSnap, &procEntry))	{ //Krijg het eerste proces in de snapshot
		return 0 ;
	}

	do {
		if (_stricmp(procEntry.szExeFile, name) == 0) { //Komt het procesnaam overeen met het gezochte proces?
			if(nextProcess==0
			|| (
			nextProcess!=0
			&& foundPreviousProcess==1
			)) {
				CloseHandle(hSnap);
				return(procEntry.th32ProcessID);

			} else {
				if(nextProcess==procEntry.th32ProcessID)
					foundPreviousProcess = 1;
			}
		}
	} while (Process32Next(hSnap, &procEntry)); //Krijg het volgende proces

	/*Het proces is niet gevonden*/
	CloseHandle(hSnap); 
	return(0);
}